﻿//////////////////////////////////////////////
// BlendState.h
//
//////////////////////////////////////////////

/// Defines / Macros -------------------------

#pragma once

/// Forward decl -----------------------------

namespace nkGraphics
{
	class System ;
}

/// Includes ---------------------------------

// nkGraphics
#include "../Dll/DllDefines.h"

#include "../Resources/Resource.h"

#include "../Utils/DxDefinesWrapper.h"

// nkExport
#include <NilkinsExport/Exportable/Exportable.h>

// nkMemory
#include <NilkinsMemory/Pointers/UniquePtr.h>

/// Class ------------------------------------
	
namespace nkGraphics
{
	class DLL_GRAPHICS_EXPORT BlendState : public Resource, public nkExport::Exportable
	{
		public :

			// Getters
			virtual bool getAlphaToCoverageEnabled () const = 0 ;
			virtual bool getIndependantBlendEnabled () const = 0 ;
			virtual bool getTargetBlendEnabled (unsigned int targetId = 0) const = 0 ;
			virtual BLEND getTargetSrcBlend (unsigned int targetId = 0) const = 0 ;
			virtual BLEND getTargetDestBlend (unsigned int targetId = 0) const = 0 ;
			virtual BLEND_OP getTargetBlendOp (unsigned int targetId = 0) const = 0 ;
			virtual BLEND getTargetSrcBlendAlpha (unsigned int targetId = 0) const = 0 ;
			virtual BLEND getTargetDestBlendAlpha (unsigned int targetId = 0) const = 0 ;
			virtual BLEND_OP getTargetBlendOpAlpha (unsigned int targetId = 0) const = 0 ;
			virtual COLOR_WRITE_ENABLE getTargetWriteMask (unsigned int targetId = 0) const = 0 ;

			// Setters
			virtual void setAlphaToCoverageEnabled (bool value) = 0 ;
			virtual void setIndependentBlendEnabled (bool value) = 0 ;
			virtual void setTargetBlendEnable (bool value, unsigned int targetId = 0) = 0 ;
			virtual void setTargetSrcBlend (BLEND type, unsigned int targetId = 0) = 0 ;
			virtual void setTargetDestBlend (BLEND type, unsigned int targetId = 0) = 0 ;
			virtual void setTargetBlendOp (BLEND_OP type, unsigned int targetId = 0) = 0 ;
			virtual void setTargetSrcBlendAlpha (BLEND type, unsigned int targetId = 0) = 0 ;
			virtual void setTargetDestBlendAlpha (BLEND type, unsigned int targetId = 0) = 0 ;
			virtual void setTargetBlendOpAlpha (BLEND_OP type, unsigned int targetId = 0) = 0 ;
			virtual void setTargetWriteMask (COLOR_WRITE_ENABLE mask, unsigned int targetId = 0) = 0 ;
			virtual void resetToDefault () = 0 ;			

			// L'export et import
			virtual void exportClassToTree (nkExport::Node* rootNode) ;
			virtual void importClassFromTree (nkExport::Node* rootNode) ;

		public :

			// Statics
			static nkMemory::UniquePtr<BlendState> create (System* system = nullptr) ;

		protected :

			// Functions
			// Constructor
			BlendState (System* system) noexcept ;
	} ;
}